<?php

// Read the contents of file.json
$fileContents = file_get_contents('file.json');

// Decode the JSON data
$data = json_decode($fileContents, true);

// Extract the required fields from each item
$channels = array();
foreach ($data['js']['data'] as $item) {
    $channel = array(
        'name' => $item['name'],
        'cmd' => $item['cmd'],
        'logo' => $item['logo']
    );
    $channels[] = $channel;
}

// Create channel.json in the same folder
$channelFile = fopen('channel.json', 'w');
if ($channelFile) {
    fwrite($channelFile, json_encode($channels));
    fclose($channelFile);
    echo "channel.json created successfully.";
} else {
    echo "Unable to create channel.json.";
}
?>
