<?php

// Read the channel.json file
$jsonFile = 'playlist.json';
$jsonData = file_get_contents($jsonFile);
$channels = json_decode($jsonData, true);

// Create the M3U playlist content
$playlistContent = '';
foreach ($channels as $channel) {
    $tvgLogo = $channel['logo'];
    $title = $channel['title'];
    $id= $channel['cmd'];
    $tvgid= $channel['tvgid'];
    $name = $channel['name'];

    $playlistContent .= "#EXTINF:-1 tvg-id=\"{$tvgid}\" tvg-logo=\"{$tvgLogo}\" group-title={$title},{$name} \n";
    $playlistContent .= "http://zcdn.site/folder/play.php?tv={$id}\n";
}

// Save the M3U playlist in the same folder as channel.json
$playlistFile = 'playlist.m3u';
file_put_contents($playlistFile, $playlistContent);

echo "M3U playlist created successfully.";

?>
