<?php
// Read channel.json and group.json
$channelData = json_decode(file_get_contents('channel.json'), true);
$groupData = json_decode(file_get_contents('group.json'), true);

// Create an associative array to map "id" to "title" from group.json
$groupTitleMap = [];
foreach ($groupData as $group) {
    $groupTitleMap[$group['id']] = $group['title'];
}

// Update the "playlist.json" file
foreach ($channelData as &$channel) {
    $id = $channel['id'];
    if (isset($groupTitleMap[$id])) {
        $channel['title'] = $groupTitleMap[$id];
    }
}

// Write the updated data back to playlist.json
file_put_contents('playlist.json', json_encode($channelData, JSON_PRETTY_PRINT));

echo 'playlist.json has been updated with group titles.';
?>
